/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.common.capability;

import mod.traister101.sns.common.SNSItemTags;
import mod.traister101.sns.util.ContainerType;
import mod.trasiter101.esc.common.capability.ExtendedSlotCapacityHandler;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ContainerItemHandler
extends ExtendedSlotCapacityHandler {
    public final ContainerType type;
    @Nullable
    private Weight cachedWeight;

    public ContainerItemHandler(ContainerType type) {
        super(type.getSlotCount(), type.getSlotCapacity());
        this.type = type;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = super.serializeNBT();
        compoundTag.m_128344_("weight", (byte)(this.cachedWeight != null ? this.cachedWeight.ordinal() : -1));
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        super.deserializeNBT(compoundTag);
        byte weight = compoundTag.m_128445_("weight");
        if (weight != -1) {
            this.cachedWeight = Weight.valueOf((int)weight);
        }
    }

    public boolean isItemValid(int slotIndex, ItemStack itemStack) {
        if (itemStack.m_204117_(SNSItemTags.PREVENTED_IN_ITEM_CONTAINERS)) {
            return false;
        }
        return this.fitsInSlot(itemStack);
    }

    protected void onContentsChanged(int slotIndex) {
        this.cachedWeight = this.isEmpty() ? Weight.LIGHT : Weight.VERY_HEAVY;
        super.onContentsChanged(slotIndex);
    }

    private boolean isEmpty() {
        for (int slotIndex = 0; slotIndex < this.getSlots(); ++slotIndex) {
            if (((ItemStack)this.stacks.get(slotIndex)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    protected final boolean fitsInSlot(ItemStack itemStack) {
        IItemSize stackSize = ItemSizeManager.get((ItemStack)itemStack);
        Size size = stackSize.getSize(itemStack);
        return size.isEqualOrSmallerThan(this.type.getAllowedSize());
    }

    public Weight getWeight() {
        if (this.cachedWeight == null) {
            return Weight.LIGHT;
        }
        return this.cachedWeight;
    }
}

